#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/cotmc/header.h"
#include "levels/bbh/header.h"

extern u8 _cotmc_segment_ESegmentRomStart[];
extern u8 _cotmc_segment_ESegmentRomEnd[];

const LevelScript level_cotmc_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _cotmc_segment_ESegmentRomStart, _cotmc_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _ccm_skybox_mio0SegmentRomStart, _ccm_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group8_mio0SegmentRomStart, _group8_mio0SegmentRomEnd),
LOAD_RAW(12, _group8_geoSegmentRomStart, _group8_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(84, 0x05002e00, 4),
// LOAD_MODEL_FROM_DL(86, 0x05003120, 4),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_9),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_cotmc_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_cotmc_1_[] = {
AREA(1, Geo_cotmc_1_0x1a4b920),
TERRAIN(col_cotmc_1_0xe0237d0),
SET_BACKGROUND_MUSIC(0, 36),
TERRAIN_TYPE(2),
JUMP_LINK(local_objects_cotmc_1_),
JUMP_LINK(local_warps_cotmc_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_cotmc_1_[] = {
OBJECT_WITH_ACTS(0, 3889, -890, -1619, 0, 268, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(124, 3391, -2064, -1332, 0, 116, 0, 0xa70000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(122, -1100, -582, 4076, 0, 270, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(85, -5700, 4136, -414, 0, 180, 0, 0x10000,  bhvCapSwitch, 31),
OBJECT_WITH_ACTS(122, 5220, 5301, 1103, 0, 271, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 3377, -1568, -3283, 0, 0, 0, 0x10000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, -3784, -1077, 4477, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 3285, -1562, 218, 0, 0, 0, 0x10000,  bhvHidden1upTrigger, 31),
OBJECT_WITH_ACTS(25, -1664, 936, 4439, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, -5530, 1286, 2647, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, -1786, -16, -3443, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 292, -1223, -230, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, -934, -791, -1016, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(25, 3279, -2064, 253, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, 3285, -1562, 218, 0, 0, 0, 0x10000,  bhvHidden1upInPoleSpawner, 31),
OBJECT_WITH_ACTS(0, -3872, 986, -118, 0, 330, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(122, 5164, 695, -4397, 0, 270, 0, 0x5000000,  bhvStar, 31),
OBJECT_WITH_ACTS(215, 3520, -1444, 4764, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1974, 2300, 3108, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2312, 7, 3968, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1171, -1750, 570, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -563, -817, 1214, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -1599, -247, -2709, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4435, 986, -3171, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5531, 1791, 2647, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, -928, 2355, -5272, 0, 181, 0, 0x6000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(137, 3009, -1227, 2410, 0, 0, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, -5333, 2736, -3732, 0, 0, 0, 0x4000000,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 1942, 2559, 3946, 0, 0, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, 3676, 5466, 3390, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 3939, 4726, 607, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(180, 4221, 5286, 2933, 0, 270, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 4184, 5286, 3835, 0, 90, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 3171, 5286, 3865, 0, 180, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 3162, 5286, 2978, 0, 360, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(223, 3430, -2064, -1017, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, -4648, 1236, 1865, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(25, -138, 936, 3161, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, 672, -1355, -7053, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 629, 1905, -4242, 0, 90, 0, 0x40000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(192, 3908, -1714, 3969, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 3380, -1714, 3536, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -4687, 986, 1152, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -481, 936, 3568, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(223, 1754, -2214, -5163, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 2596, 2022, 3634, 0, 0, 0, 0x0,  bhvChuckya, 23),
OBJECT_WITH_ACTS(137, -1576, -555, 794, 0, 0, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(212, -4098, 336, 3664, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(180, -503, -585, -270, 0, 0, 0, 0x40000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -2598, 1193, -2512, 0, 0, 0, 0x40000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(194, -1072, 1345, 4084, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(194, 903, 1446, 4989, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(207, 3915, 4036, 697, 0, 0, 0, 0x10000,  bhvFloorSwitchHiddenObjects, 31),
OBJECT_WITH_ACTS(129, 3590, 4050, 355, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 3091, 4326, 348, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 3091, 4494, 941, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, 3091, 4716, 1439, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(0, -4064, -1227, 3979, 0, 0, 0, 0x10000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, -2071, 1192, 4813, 0, 0, 0, 0x20000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(137, 631, -467, -5922, 0, 0, 0, 0x10000,  bhvExclamationBox, 31),
RETURN()
};

const LevelScript local_warps_cotmc_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(1, 28, 1, 2, 0),
WARP_NODE(2, 28, 1, 1, 0),
WARP_NODE(240, 6, 2, 45, 0),
WARP_NODE(241, 6, 2, 55, 0),
RETURN()
};
